///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 27/04/07		Hounddog	Initial implementation
//

namespace MonoScan
{
	using System;
	using System.Xml;

	/// <summary>
	/// Base class for control unit specific scanners. Scanner extends MainForm 
	/// by adding menu items and forms, appropriate for its control units family.
	/// 
	/// On the construction scanner receives XML node containing all the metadata
	/// to interpret data received from the control unit.
	/// 
	/// Put each scanner and the realated classes into a separate namespace and 
	/// directory. See MonoMotronic121 for an example.
	/// </summary>
	public class Scanner : IDisposable
	{
		public Scanner(MainForm mainForm, XmlNode xmlNode)
		{
			this.mainForm = mainForm;
			this.xmlNode = xmlNode;
			
			disposed = false;
		}

		protected XmlNode xmlNode;

		public MainForm MainForm
		{
			get { return mainForm; }
		}

		protected MainForm mainForm;		

		~Scanner()
		{
			Dispose(false);
		}

		public void Dispose()
		{
			if (! disposed)
			{
				Dispose(true);
				disposed = true;

				GC.SuppressFinalize(this);				
			}
		}

		bool disposed;

		/// <summary>
		/// Can be called any time after construction one time
		/// </summary>
		protected virtual void Dispose(bool disposing) 
		{ 
		}
	}
}